<?php
session_start();
include 'conexao.php';

// Restringir o acesso apenas ao Diretor Pedagógico
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'SUBDIRECÇÃO PEDAGÓGICA') {
    header("Location: login.php");
    exit;
}

$mensagem = '';

// Pegar os valores do POST/GET
$trimestre_selecionado = trim($_REQUEST['trimestre_select'] ?? $_REQUEST['trimestre'] ?? null);
$tipo_prova_selecionado = trim($_REQUEST['tipo_prova_select'] ?? $_REQUEST['tipo_prova'] ?? null);

// Ação: fechar ou reabrir
$acao = trim($_REQUEST['acao'] ?? 'fechar');

$ano_lectivo_atual = "2025/2026";
$status_valor = ($acao === 'reabrir') ? 0 : 1;
$status_texto = ($acao === 'reabrir') ? 'Reabertura' : 'Fecho';
$status_verbo = ($acao === 'reabrir') ? 'reaberto' : 'bloqueado';

if ($tipo_prova_selecionado && in_array($acao, ['fechar', 'reabrir'])) {
    try {
        $coluna_a_atualizar = '';
        $nome_prova = '';

        if ($tipo_prova_selecionado === 'NPP') {
            $coluna_a_atualizar = 'npp_fechada';
            $nome_prova = 'Nota de Provas e Participação (NPP)';
        } elseif ($tipo_prova_selecionado === 'NPT') {
            $coluna_a_atualizar = 'npt_fechada';
            $nome_prova = 'Nota de Participação e Trabalhos (NPT)';
        } else {
            throw new Exception("Tipo de nota selecionado ($tipo_prova_selecionado) não é válido para fecho/reabertura.");
        }

        // Inicia transação
        $conn->begin_transaction();

        // Atualiza TODAS as linhas do ano lectivo
        $sql = "
            UPDATE notas
            SET {$coluna_a_atualizar} = ?
            WHERE ano_lectivo = ?
        ";

        $stmt_update_notas = $conn->prepare($sql);

        if (!$stmt_update_notas) {
            throw new Exception("Erro na preparação da query de atualização: " . $conn->error);
        }

        $stmt_update_notas->bind_param("is", $status_valor, $ano_lectivo_atual);

        $stmt_update_notas->execute();

        $linhas_afetadas = $conn->affected_rows;

        $stmt_update_notas->close();
        $conn->commit();

        $classe_cor = ($status_valor === 0) ? 'alert-info' : 'alert-success';
        $icone = ($status_valor === 0) ? '🔓' : '🔒';

        $mensagem = "
            <div class='alert {$classe_cor}'>
                <h3>$icone <strong>{$status_texto} CONCLUÍDA!</strong></h3>
                <p>
                    <strong>$linhas_afetadas</strong> registros de notas atualizados.<br>
                    O lançamento e edição da <strong>{$nome_prova}</strong> do
                    <strong>{$trimestre_selecionado}º Trimestre</strong> foi <strong>{$status_verbo}</strong> para todo o sistema.
                </p>
            </div>
        ";

    } catch (Exception $e) {
        if (isset($conn) && $conn->ping()) {
            $conn->rollback();
        }
        $mensagem = "<div class='alert alert-error'>❌ <strong>ERRO:</strong> " . $e->getMessage() . "</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestão de Lançamentos | Subdireção Pedagógica</title>

    <style>
        :root {
            --cor-principal: #3a8ee6;
            --cor-fundo: #f4f7f6;
            --cor-card: #ffffff;
            --cor-sucesso: #28a745;
            --cor-alerta: #007bff;
            --cor-erro: #dc3545;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--cor-fundo);
            color: #333;
            margin: 0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
        }

        .container {
            width: 100%;
            max-width: 600px;
            background-color: var(--cor-card);
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        h2 {
            color: var(--cor-principal);
            border-bottom: 3px solid #eee;
            padding-bottom: 10px;
            margin-top: 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        h2::before {
            content: '🎓';
            font-size: 1.2em;
        }

        p {
            color: #555;
            margin-bottom: 25px;
            line-height: 1.6;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            font-weight: 600;
            margin-bottom: 8px;
            color: #333;
        }

        select {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ccc;
            border-radius: 8px;
            font-size: 16px;
            background-color: #f9f9f9;
        }

        select:focus {
            border-color: var(--cor-principal);
            outline: none;
            box-shadow: 0 0 5px rgba(58, 142, 230, 0.5);
        }

        .btn-group {
            display: flex;
            gap: 15px;
            margin-top: 30px;
            justify-content: center;
        }

        button {
            padding: 12px 25px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 700;
            transition: 0.3s;
        }

        .btn-fechar {
            background-color: #dc3545;
            color: white;
        }

        .btn-reabrir {
            background-color: var(--cor-principal);
            color: white;
        }

        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 25px;
            border-left: 5px solid;
            font-weight: 500;
        }

        .alert-success {
            background-color: #d4edda;
            color: #155724;
            border-color: var(--cor-sucesso);
        }

        .alert-info {
            background-color: #e6f7ff;
            color: #0056b3;
            border-color: var(--cor-alerta);
        }

        .alert-error {
            background-color: #f8d7da;
            color: var(--cor-erro);
            border-color: var(--cor-erro);
        }

        @media (max-width: 650px) {
            .btn-group {
                flex-direction: column;
                gap: 10px;
            }
            button {
                width: 100%;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Gestão de Lançamentos 📝</h2>
    <p>Este painel permite à Subdireção Pedagógica bloquear (Fechar) ou desbloquear (Reabrir) o lançamento de notas por trimestre.</p>

    <?= $mensagem ?>

    <form method="POST">
        <div class="form-group">
            <label for="trimestre_select">Selecione o Trimestre:</label>
            <select name="trimestre_select" id="trimestre_select">
                <option value="">-- Escolha o Trimestre --</option>
                <option value="1" <?= ($trimestre_selecionado == '1' ? 'selected' : '') ?>>1º Trimestre</option>
                <option value="2" <?= ($trimestre_selecionado == '2' ? 'selected' : '') ?>>2º Trimestre</option>
                <option value="3" <?= ($trimestre_selecionado == '3' ? 'selected' : '') ?>>3º Trimestre</option>
            </select>
        </div>

        <div class="form-group">
            <label for="tipo_prova_select">Selecione o Tipo de Nota:</label>
            <select name="tipo_prova_select" id="tipo_prova_select" required>
                <option value="">-- Escolha a Categoria de Nota --</option>
                <option value="NPP" <?= ($tipo_prova_selecionado == 'NPP' ? 'selected' : '') ?>>NPP</option>
                <option value="NPT" <?= ($tipo_prova_selecionado == 'NPT' ? 'selected' : '') ?>>NPT</option>
            </select>
        </div>

        <div class="btn-group">
            <button type="submit" name="acao" value="fechar" class="btn-fechar">🔒 Bloquear Lançamento</button>
            <button type="submit" name="acao" value="reabrir" class="btn-reabrir">🔓 Reabrir Lançamento</button>
        </div>
    </form>
</div>

</body>
</html>
